
/*
  CLASSiC DAC, Copyright 2013 SILICON CHIP Publications
  DCI.h: functions to use the Data Converter Interface to generate a continuous S/PDIF digital audio stream from a buffered filled with PCM data
  Written by Nicholas Vinen, 2010-2013
*/

#ifndef _DCI_H_
#define _DCI_H_

#include "types.h"

#define DCI_BUFFER_PAGES 21

extern volatile unsigned char DCIBuffer_full, DCIBuffer_underrun;
extern unsigned char DCI_BitDepth;

void DCI_Setup();
unsigned long DCI_Measure_Clock_Frequency(unsigned short Period_ms);

void DCI_Start_SPDIF_Transmission();
void DCI_Write(const signed short* data, unsigned char num_channels);
signed short* DCI_Prepare_Write_2_Channel();
signed short* DCI_Prepare_Write_2_Channel_Size(unsigned char* NumBlocks);
void DCI_Commit_Write_2_Channel();
void DCI_Commit_Write_2_Channel_Size(unsigned char NumBlocks);
void DCI_Pause(bool Paused);
void DCI_Clear_Buffer();
void DCI_Reset_Buffer();
unsigned char* DCI_Get_Buffer();
bool DCI_Is_Running();
bool DCI_Write_Will_Be_on_24bit_Boundary();
void DCI_Sampling_Rate_Changed(unsigned long rate);

unsigned char DCI_Set_Filtering(bool bEnabled, unsigned long LowCrossoverFrequency, unsigned long HighCrossoverFrequency, signed short BassBoost, signed short TrebleBoost, unsigned char FixedScale);
bool DCI_Get_Filtering(unsigned long* pLowCrossoverFrequency, unsigned long* pHighCrossoverFrequency, signed short* pBassBoost, signed short* pTrebleBoost);

#endif//_DCI_H_
